% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdAgglomerative.details.R
\name{mdAgglomerative.details}
\alias{mdAgglomerative.details}
\title{Matrix distance by distance and approach type.}
\usage{
mdAgglomerative.details(list, distance, approach)
}
\arguments{
\item{list}{is a clusters list.}

\item{distance}{is a literal. The distance type to be used.}

\item{approach}{is a literal. The approach type to be used.}
}
\value{
A matrix distance. Explanation.
}
\description{
To explain how to calculate the matrix distance by using \code{distance} and \code{approach} type.
}
\details{
This function is part of the hierarchical clusterization method. The function calculates the
matrix distance by using the distance and approach type given.

The \code{list} parameter will be a list with the clusters as rows and columns.

The function avoids distances equal 0 and undefined clusters.
}
\examples{

data <- c(1,2,1,3,1,4,1,5,1,6)

clusters <- toList(data)

mdAgglomerative.details(clusters, 'EUC', 'MAX')

mdAgglomerative.details(clusters, 'CHE', 'AVG')

}
\author{
Roberto Alcántara \email{roberto.alcantara@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
