% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_structure.R
\name{extract_structure}
\alias{extract_structure}
\title{Image of the data structure}
\usage{
extract_structure(
  model = NULL,
  n_gf = NULL,
  gf_description = NULL,
  gf_names = NULL,
  gf_nlevels = NULL,
  gf3_index = "i",
  label_levels = "yes",
  export_type = "print"
)
}
\arguments{
\item{model}{Code for fitting a \code{\link[nlme:lme]{nlme::lme()}} or \code{\link[lme4:lmer]{lme4::lmer()}} model given
as a string.}

\item{n_gf}{Number of groups or grouping factors: \code{1}, \code{2}, or \code{3}. Only
applies if \code{model} is \code{NULL}.}

\item{gf_description}{Description of the structure of the groups or grouping
factors: \code{"nested"}, \code{"crossed"}, \code{"crossed with nested"}, or
\code{"crossed within nested"}. Only applies if \code{n_gf} is greater than \code{1} and
\code{model} is \code{NULL}.}

\item{gf_names}{Character vector of the names of group(s) or grouping
factor(s). For nested, order names by level from highest to lowest. Must be
a vector of length equal to \code{n_gf}. Only applies if \code{model} is \code{NULL}.}

\item{gf_nlevels}{Optional numeric or character vector of the number of
levels for each group or grouping factor in the \code{model} or \code{gf_names}.}

\item{gf3_index}{String for the index of the highest-level group or grouping
factor. Only applies if \code{n_gf} is \code{3}. Default is \code{"i"}.}

\item{label_levels}{Indicates whether levels of the data structure should be
labeled on the left-hand side of the figure (default) or not
(\code{label_levels} = \code{"no"}).}

\item{export_type}{Export type can be \code{"print"} (default), \code{"png"} to save
as a PNG file, or \code{"text"} to get the input used to run
\code{\link[DiagrammeR:grViz]{DiagrammeR::grViz()}}.}
}
\value{
A PNG (\code{export_type = "png"}), character
(\code{export_type = "text"}), or object of class htmlwidget that will print
in the R console, within R Markdown documents, and within Shiny output
bindings (\code{export_type = "print"}).
}
\description{
\code{extract_structure} generates an image of the multilevel data structure. It
does this in two steps. First, characteristics of the group(s) or grouping
factor(s) are identified via the \code{model} input or the \code{n_gf},
\code{gf_description}, and \code{gf_names} inputs. Second, this information is used to
run \code{\link[DiagrammeR:grViz]{DiagrammeR::grViz()}}, which returns an image.
}
\examples{
# Using the model input
extract_structure(model = "lme(Score ~ type, random=list(School=pdDiag(~1+type),Class=~1))")
extract_structure(model = "lme(Weight ~ Time, random=~Time|Subject, data)",
                  gf_nlevels = 47)
extract_structure(model = "lmer(Strength ~ 1 + (1|Machine) + (1|Worker))",
                  gf_nlevels = c("23", "J"))

# Using the n_gf, gf_description, and gf_names inputs
extract_structure(n_gf = 1,
                  gf_names = "Subject")
extract_structure(n_gf = 3,
                  gf_description = "nested",
                  gf_names = c("District", "School", "Class"),
                  gf_nlevels = c(8, 15, 5),
                  label_levels = "no")
}
