% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/competitors.R
\name{get_neighbors}
\alias{get_neighbors}
\title{Get phonological neighbors}
\usage{
get_neighbors(
  target,
  lexicon,
  neighbors = "das",
  sep = " ",
  form = FALSE,
  count = FALSE
)
}
\arguments{
\item{target}{Character string containing a target word}

\item{lexicon}{Character vector containing the lexical database}

\item{neighbors}{(\emph{get_neighbors} only) Character vector specifying the
type of neighbor to return. Return the delete, add, substitute neighbors of
the target when 'd', 'a', and/or 's' is in neighbors respectively}

\item{sep}{Separator in target and lexicon}

\item{form}{Whether to return words in lexicon}

\item{count}{Whether to return count of words}
}
\value{
the indexes of the competitors in the lexical database
}
\description{
Phonological neighbors are items which can be converted
to the target by one add, delete and substitute operation
}
\examples{
get_neighbors("AA R K", c("AA R K", "AA R", "B AA B"), "d")
get_neighbors("AA R K", c("AA R K", "AA R", "B AA B"), "da")
get_neighbors("AA R K", c("AA R K", "AA R", "B AA B"), "das")
}
