% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexis_grid.R
\name{lexis_grid}
\alias{lexis_grid}
\title{Plot a Lexis grid}
\usage{
lexis_grid(year_start, year_end, age_start, age_end, delta = 1,
  lwd = 0.3, force_equal = TRUE)
}
\arguments{
\item{year_start}{integer, set the year the Lexis Diagram starts with.}

\item{year_end}{integer, set the year the Lexis Diagram ends with.}

\item{age_start}{integer, set the age the Lexis Diagram starts with.}

\item{age_end}{integer, set the age the Lexis Diagram ends with.}

\item{delta}{numeric, set the size of the age groups. Default is 1.}

\item{lwd}{numeric, set the linewidth of the grid.}

\item{force_equal}{logical, by default \code{lexis.grid} uses \code{ggplot2::coord_fixed()} to ensure isosceles trianlges. Set \code{FALSE} to allow for a non-isosceles appearance.}
}
\value{
A ggplot object.
}
\description{
lexis_grid() plots the basic Lexis grid.
}
\details{
The function determines the aspect ratio of the x- and y-axis to enforce
isosceles triangles. The aspect ratio will not be effected by defining
\code{width} and \code{height} in \code{pdf()} or other graphic devices.

Because the returned object is a ggplot2 graph, the overall appearence of
the graph can be edited by adding \code{themes()} to the plot.
}
\examples{
library(LexisPlotR)
lexis_grid(year_start = 1900, year_end = 1905, age_start = 0, age_end = 5)
}
\author{
Philipp Ottolinger
}
