% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lsys.R
\name{Lsys}
\alias{Lsys}
\title{Rewrite an Axiom Using Production Rules to Give a String Ready for Turtle Graphics}
\usage{
Lsys(init = NULL, rules = NULL, n = 5, retAll = TRUE, verbose = 1L)
}
\arguments{
\item{init}{A character string giving variables (symbols) to use as the initial string
Also known as the axiom.}

\item{rules}{A data frame containing columns "inp" and "out".  These contain the input
variables and the corresponding replacement string.  See the examples in
\code{\link{drawLsys}}.}

\item{n}{An integer giving the number of cycles or iterations desired.}

\item{retAll}{Logical.  If \code{TRUE}, the result at each cycle will be returned,
otherwise only the last result is returned.}

\item{verbose}{An integer giving the level of information desired as the calculation
proceeds.  \code{verbose = 1L} gives basic information at each cycle.
Any value greater than 1 gives much more detail.  Supress messages by using a value
less than 1.}
}
\value{
If \code{retAll = FALSE}, a character vector of length 1 giving the string
at the end processing.  Otherwise, a character vector of length \code{n + 1}
containing \code{init} plus the results at the end of each iteration.
}
\description{
This is the central function for rewriting an initial string of symbols (the axiom)
into a new string using production rules.  Production rules are very simple: if
the symbol is A, turn it into something.  If it is B, turn it into something else.
Production rules typically contain instructions about moving while drawing,
moving w/o drawing, changing direction, or storing the current state for re-use later.
}
\details{
The job of this function is to take an input "axiom" and apply the "production
rules" and other paramters to create a new string of drawing instructions.  The
"language" or character set of the axiom and production rules are arbitary, and
the internet and literature contains many different examples.  The same fractal
could be drawn using completely different sets of symbols.  The string produced
by this function is processed by \code{\link{drawLsys}}.  See there for further
explanation and examples.
}
\seealso{
\code{\link{drawLsys}} for examples, including plotting.
}
\keyword{utilities}
