% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaudermanModelling.R
\name{createGoudermanData}
\alias{createGoudermanData}
\title{Create the Gouderman Data Arrangement.}
\usage{
createGoudermanData(selectedLDO, breaks, center, timeperiod = NA, range = NA)
}
\arguments{
\item{selectedLDO}{Longitudinal Data Object, containing all selected metabolites to be used for the final Gouderman model.}

\item{breaks}{break points for the spline model}

\item{center}{Time point that corresponds to the center time t0. The algorithm will test whether there is a significant difference between the groups at this point.}

\item{timeperiod}{If the user defines the time period or segment, in the spline to be tested. Note, a 3 break point spline has 4 segments.}

\item{range}{If the user defines a range, the algorithm will test whether there is a significant difference between the groups in this range.}
}
\value{
The function returns a 'GaudermanLDO' object. For more information @seealso 'GaudermanLDO' .
}
\description{
Using the Gouderman methodology to create the Gouderman-Data Arrangement.
}
\examples{
\dontrun{
} 
  data(LoBraExample)
  selectedLDO <- selectComponents(ldo, components)
  breaks<- c(8, 12)
  center<- 12
  timeperiod <- 2;
  gaudermanLDOexample <- createGoudermanData(selectedLDO, breaks, center, timeperiod)
  
}
