% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catchability.R
\name{catchability}
\alias{catchability}
\title{This function calculates the probability of entry into a trap, also known as catchability. It includes the parameters described
in Addison and Bell (1997), and can also incorporate the length of the catch while calculating the catchability.}
\usage{
catchability(
  q0,
  qmin,
  saturationThreshold,
  Ct,
  lengthBased,
  lobLengthThreshold,
  lobSize = NA,
  sexBased,
  lobSex
)
}
\arguments{
\item{q0}{is the initial probability of entry into an empty trap (range is from 0-1). Default value is 0.5.}

\item{qmin}{is the asymptotic minimum probability of entry with default value being 0.}

\item{saturationThreshold}{is the number of lobsters in a trap at which the probability of
another lobster entering the trap is zero (i.e. no more entry due to agnostic  behavior of trapped lobsters).}

\item{Ct}{is the number of caught lobster}

\item{lengthBased}{Logical. If TRUE the length of lobsters caught will be taken into account}

\item{lobLengthThreshold}{Logical.If TRUE the carapace length (in milliliters) beyond which there is no chance of catching another lobster due to bold agnostic  behavior of large lobsters.}

\item{lobSize}{is a size frequency dataset that is representative of the population and can be incorporated to the model.}

\item{sexBased}{Logical. If TRUE, lobster sex is taken into account and user must provide a list containing sex distribution for the simulated population}

\item{lobSex}{is the sex of trapped lobster}
}
\value{
Returns the probability of entry to trap.
}
\description{
This function calculates the probability of entry into a trap, also known as catchability. It includes the parameters described
in Addison and Bell (1997), and can also incorporate the length of the catch while calculating the catchability.
}
\references{
Julian T. Addison and Michael C. Bell (1997), Simulation modelling of capture processes in trap fisheries for clawed
lobsters, Marine Freshwater Research, 48(8), 1035-1044, https://www.publish.csiro.au/MF/MF97169
}
