% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.fasta.R
\name{read.fasta}
\alias{read.fasta}
\title{Read FASTA Files}
\usage{
read.fasta(file)
}
\arguments{
\item{file}{A string specifying the path to a FASTA file to read.}
}
\value{
A data frame with fields for sequence names and sequences.
}
\description{
Reads FASTA files. Supports the reading of FASTA files with sequences wrapping multiple lines.
}
\examples{
# Get path to example FASTA file.
path_to_fasta_file<-system.file("extdata",
                                "example_query_sequences.fasta",
                                package="LocaTT",
                                mustWork=TRUE)

# Read the example FASTA file.
read.fasta(file=path_to_fasta_file)
}
\seealso{
\code{\link[=write.fasta]{write.fasta}} for writing FASTA files. \cr
\code{\link[=read.fastq]{read.fastq}} for reading FASTQ files. \cr
\code{\link[=write.fastq]{write.fastq}} for writing FASTQ files.
}
