% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MCMC_MABOUST}
\alias{MCMC_MABOUST}
\title{Obtains posterior samples from the MABOUST design for use in trial decision making.
Performs posterior sampling for the MABOUST design and determines whether the trial should continue and what treatment(s) are optimal.}
\usage{
MCMC_MABOUST(Y, T, X, B, NTreat, NOUT, PSPIKE, ADJ)
}
\arguments{
\item{Y}{Ordinal Outcome Vector, labeled 1,...,J}

\item{T}{Treatment Indicator, labeled 1,...,K.}

\item{X}{Matrix of patient covariates.}

\item{B}{Number of MCMC iterations to perform.}

\item{NTreat}{Number of treatments in consideration, i.e. K.}

\item{NOUT}{Number of ordinal outcome categories, i.e. J.}

\item{PSPIKE}{Prior probability of a pairwise null. PSPIKE=1 means no clustering is possible.}

\item{ADJ}{Integer for whether or not we should adjust for covariates.}
}
\value{
Posterior samples for use in the MABOUST design.
}
\description{
Obtains posterior samples from the MABOUST design for use in trial decision making.
Performs posterior sampling for the MABOUST design and determines whether the trial should continue and what treatment(s) are optimal.
}
