% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/some_helper_functions.R
\name{zs}
\alias{zs}
\alias{zu}
\alias{zr}
\alias{zq}
\title{Standardisation functions for models}
\usage{
zs(x)

zu(x)

zr(x)

zq(x)
}
\arguments{
\item{x}{A numeric vector}
}
\value{
a standardised vector containing the parameters needed for use in prediction with new data
}
\description{
These functions are for use in fitting linear models (or allies) with scaled
predictors, in such a way that when the fitted model objects are used for
prediction (or visualisation) the same scaling parameters will be used with
the new data.
}
\examples{
fm <- lm(Gas ~ Insul/zs(Temp), whiteside)
gm <- lm(Gas ~ Insul/zu(Temp), whiteside)
hm <- lm(Gas ~ Insul/Temp,     whiteside)
c(fm = unname(predict(fm, data.frame(Insul = "Before", Temp = 0.0))),
  gm = unname(predict(gm, data.frame(Insul = "Before", Temp = 0.0))),
  hm = unname(predict(hm, data.frame(Insul = "Before", Temp = 0.0))))
rm(fm, gm, hm)
}
