% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imcid.R
\name{imcid}
\alias{imcid}
\title{Point and interval estimation for the MCID at the individual level}
\usage{
imcid(x, y, z, n, lambda, delta, maxit = 100, tol = 0.01, alpha = 0.05)
}
\arguments{
\item{x}{a continuous variable denoting the outcome change of interest}

\item{y}{a binary variable indicating the patient-reported outcome derived from the anchor question}

\item{z}{a vector or matrix denoting the patient's clinical profiles}

\item{n}{the sample size}

\item{lambda}{the selected tuning parameter \eqn{\lambda}, can be returned by \code{cv.imcid}}

\item{delta}{the selected tuning parameter \eqn{\delta}, can be returned by \code{cv.imcid}}

\item{maxit}{the maximum number of iterations. Defaults to 100}

\item{tol}{the convergence tolerance. Defaults to 0.01}

\item{alpha}{nominal level of the confidence interval. Defaults to 0.05}
}
\value{
a list including the point estimates for the linear coefficients of the individualized MCID and their standard errors, and the corresponding confidence intervals based on the asymptotic normality
}
\description{
We formulate the individualized MCID as a linear function of the patients' clinical profiles. \code{imcid} returns the point estimate for the linear coefficients of the MCID at the individual level
}
\examples{
\donttest{
n <- 500
lambdaseq <- 10 ^ seq(-3, 3, 0.1)
deltaseq <- seq(0.1, 0.3, 0.1)
a <- 0.1
b <- 0.55
c <- -0.1
d <- 0.45
### True linear coefficients of the individualized MCID: ###
### beta0=0, beta1=0.5 ###

set.seed(115)
p <- 0.5
y <- 2 * rbinom(n, 1, p) - 1
z <- rnorm(n, 1, 0.1)
y_1 <- which(y == 1)
y_0 <- which(y == -1)
x <- c()
x[y_1] <- a + z[y_1] * b + rnorm(length(y_1), 0, 0.1)
x[y_0] <- c + z[y_0] * d + rnorm(length(y_0), 0, 0.1)
sel <- cv.imcid(x = x, y = y, z = z, lamseq = lambdaseq,
         delseq = deltaseq, k = 5, maxit = 100, tol = 1e-02)
lamsel <- sel$'Selected lambda'
delsel <- sel$'Selected delta'
result <- imcid(x = x, y = y, z = z, n = n, lambda = lamsel,
         delta = delsel, maxit = 100, tol = 1e-02, alpha = 0.05)
result$'Point estimates'
result$'Standard errors'
result$'Confidence intervals'
}
}
