% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGDrivE-Auxiliary.R
\name{aggregateFemales}
\alias{aggregateFemales}
\title{Aggregate Female Output by Genotype}
\usage{
aggregateFemales(
  readDir,
  writeDir = NULL,
  genotypes,
  remFile = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{readDir}{Directory to read input from}

\item{writeDir}{Directory to write output to. Default is readDir}

\item{genotypes}{Character vector of possible genotypes; found in \code{driveCube$genotypesID}}

\item{remFile}{Boolean flag to remove original (unaggregated) file}

\item{verbose}{Chatty? Default is TRUE}
}
\description{
Aggregate over male mate genotype to convert female matrix output into vector output.
}
\examples{
\dontrun{
# This example assumes user has already run MGDrivE and generated output.
#  This also assumes that the user has already split output by patch.
# See vignette for complete example.

# set read/write directory
fPath <- "path/to/data/containing/folder"

# Need genotypes from the cube run in the simulation
#  This is dependent on the simulation run
#  Using Mendelian cube for this example
cube <- cubeMendelian()

# no return value from function
aggregateFemales(readDir= fPath, writeDir = NULL, genotypes = cube$genotypesID,
                 remFile = TRUE)
}

}
