% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{Interface}
\alias{Interface}
\title{Interface}
\value{
The downloaded file path

Message displaying success and location of downloaded tiles
}
\description{
Interface

Interface
}
\details{
Interface class for interacting with WMS, WFS, and WMTS Streaming classes.

This class provides a unified interface to access the WMS, WFS, and WMTS Streaming classes.

The `search` function performs a search for features within the specified bounding box and/or with a specified filter.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{mgp_sdk}}{(Optional) An instance of the MGP_SDK Python library. If NULL, a new instance will be created. Default is NULL.}

\item{\code{py_interface}}{(Optional) An instance of the Interface class from the MGP_SDK Python library. If NULL, a new instance will be created. Default is NULL.}

\item{\code{env_name}}{= (Optional) The name of the environment where the MGP_SDK Python library is installed. Default is "R-MGP-SDK".}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Interface-new}{\code{Interface$new()}}
\item \href{#method-Interface-streaming_search}{\code{Interface$streaming_search()}}
\item \href{#method-Interface-streaming_download_image}{\code{Interface$streaming_download_image()}}
\item \href{#method-Interface-streaming_get_full_res_image}{\code{Interface$streaming_get_full_res_image()}}
\item \href{#method-Interface-basemaps_search}{\code{Interface$basemaps_search()}}
\item \href{#method-Interface-basemaps_download_image}{\code{Interface$basemaps_download_image()}}
\item \href{#method-Interface-basemaps_download_tiles}{\code{Interface$basemaps_download_tiles()}}
\item \href{#method-Interface-discovery_stac_search}{\code{Interface$discovery_stac_search()}}
\item \href{#method-Interface-discovery_search_by_audit_fields}{\code{Interface$discovery_search_by_audit_fields()}}
\item \href{#method-Interface-discovery_get_root_catalog}{\code{Interface$discovery_get_root_catalog()}}
\item \href{#method-Interface-discovery_get_collection_definition}{\code{Interface$discovery_get_collection_definition()}}
\item \href{#method-Interface-discovery_get_all_collections}{\code{Interface$discovery_get_all_collections()}}
\item \href{#method-Interface-discovery_get_stac_item}{\code{Interface$discovery_get_stac_item()}}
\item \href{#method-Interface-discovery_get_top_level_sub_catalog}{\code{Interface$discovery_get_top_level_sub_catalog()}}
\item \href{#method-Interface-discovery_get_sub_catalog}{\code{Interface$discovery_get_sub_catalog()}}
\item \href{#method-Interface-discovery_get_sub_catalog_collection_definition}{\code{Interface$discovery_get_sub_catalog_collection_definition()}}
\item \href{#method-Interface-clone}{\code{Interface$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-new"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-new}{}}}
\subsection{Method \code{new()}}{
Initializes the `Interface` object. Sets up the environment for using the MGP_SDK Python library.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$new(mgp_sdk = NULL, py_interface = NULL, env_name = "R-MGP-SDK")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mgp_sdk}}{(Optional) An instance of the MGP_SDK Python library. If NULL, a new instance will be created. Default is NULL.}

\item{\code{py_interface}}{(Optional) An instance of the Interface class from the MGP_SDK Python library. If NULL, a new instance will be created. Default is NULL.}

\item{\code{env_name}}{(Optional) The name of the environment where the MGP_SDK Python library is installed. Default is "R-MGP-SDK".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-streaming_search"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-streaming_search}{}}}
\subsection{Method \code{streaming_search()}}{
Perform a search for features within the specified bounding box and/or with a specified filter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$streaming_search(
  bbox = NULL,
  filter = NULL,
  shapefile = FALSE,
  csv = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bbox}}{A string indicating the bounding box of the area of interest (miny,minx,maxy,maxx).}

\item{\code{filter}}{A string containing a CQL filter used to refine the data of the search. Default is NULL.}

\item{\code{shapefile}}{A logical indicating whether to return a shapefile. Default is FALSE.}

\item{\code{csv}}{A logical indicating whether to return a CSV file. Default is FALSE.}

\item{\code{...}}{Additional arguments to pass to the `search` method.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If `shapefile` is TRUE, the function returns a shapefile of all features and associated metadata.
If `csv` is TRUE, the function returns a CSV file. If neither is specified, the function returns a list of features.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-streaming_download_image"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-streaming_download_image}{}}}
\subsection{Method \code{streaming_download_image()}}{
Download an image from a WMS or WMTS service


This function allows you to download an image from a Web Map Service (WMS) or a


Web Map Tile Service (WMTS). You can specify the bounding box, image dimensions, image


format, and other parameters to customize the downloaded image.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$streaming_download_image(
  bbox = NULL,
  srsname = "EPSG:4326",
  height = NULL,
  width = NULL,
  img_format = "jpeg",
  identifier = NULL,
  zoom_level = NULL,
  download = TRUE,
  outputpath = NULL,
  display = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bbox}}{A vector of four numeric values specifying the bounding box of the image.}

\item{\code{srsname}}{A string specifying the spatial reference system (SRS) of the bounding box. Default is "EPSG:4326".}

\item{\code{height}}{The height of the image in pixels.}

\item{\code{width}}{The width of the image in pixels.}

\item{\code{img_format}}{A string specifying the image format. Must be one of "jpeg", "png", or "geotiff".}

\item{\code{identifier}}{A string specifying the identifier of the image.}

\item{\code{zoom_level}}{An integer specifying the zoom level of the WMTS image.}

\item{\code{download}}{A logical value indicating whether to download the image (TRUE) or return the raw image data (FALSE).}

\item{\code{outputpath}}{A string specifying the directory where the downloaded image should be saved.}

\item{\code{display}}{A logical value indicating whether to display the downloaded image (TRUE) or not (FALSE).}

\item{\code{gridoffsets}}{A vector of two numeric values specifying the grid offsets of the image.}

\item{\code{...}}{Additional parameters to be passed to the WMS or WMTS service.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If `download` is TRUE, the function returns the filename of the downloaded image. If `download` is FALSE,
the function returns the raw image data as a binary vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-streaming_get_full_res_image"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-streaming_get_full_res_image}{}}}
\subsection{Method \code{streaming_get_full_res_image()}}{
This function is a wrapper for a Python function that retrieves full resolution images.


The function downloads an image with the specified feature ID and additional parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$streaming_get_full_res_image(
  featureid,
  thread_number = 100,
  bbox = NULL,
  mosaic = FALSE,
  srsname = "EPSG:4326",
  outputdirectory = getwd(),
  image_format = "jpeg",
  filename = "Maxar_Download"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{featureid}}{A character string representing the unique ID of the feature for which the image is required.}

\item{\code{thread_number}}{An integer indicating the number of threads to use for the download process. Default is 100.}

\item{\code{bbox}}{A character string representing the bounding box coordinates in the format 'xmin, ymin, xmax, ymax'. If NULL, the bounding box will be determined based on the feature ID. Default is NULL.}

\item{\code{mosaic}}{A logical value indicating whether to mosaic the images or not. If TRUE, images covering the defined area will be combined into a single image. Default is FALSE.}

\item{\code{srsname}}{A character string representing the spatial reference system to be used for the image. Default is 'EPSG:4326'.}

\item{\code{outputdirectory}}{A character string representing the directory where the image should be saved. If NULL, the image will be saved in the current working directory. Default is NULL.}

\item{\code{image_format}}{A character string representing the format of the image file to be downloaded. Default is 'jpeg'.}

\item{\code{filename}}{A character string representing the name of the file to be saved. Default is "Maxar_Download".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The function returns the result of the Python function call. The nature of this result depends on the Python function implementation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-basemaps_search"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-basemaps_search}{}}}
\subsection{Method \code{basemaps_search()}}{
Function searchs using WFS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$basemaps_search(
  bbox,
  srsname = "EPSG:4326",
  filter,
  shapefile = FALSE,
  csv = FALSE,
  seamlines = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bbox}}{Type:str, Bounding box of the AOI. Comma delimited set of coordinates. (miny,minx,maxy,maxx)}

\item{\code{srsname}}{Type:str, The desired projection. Defaults to EPSG:4326}

\item{\code{filter}}{Type: str, CQL filter used to refine the data returned from the search.}

\item{\code{shapefile}}{Type: bool, Optional Boolean of whether to return in shapefile format. Defaults to false}

\item{\code{csv}}{Type: bool, Optional Boolean of whether to return in csv format. Defaults to false}

\item{\code{featureprofile}}{Type: str, Optional. Represents the desired stacking profile. Defaults to account default.}

\item{\code{typename}}{Type:str, Optional The typename of the desired feature type. Defaults to FinishedFeature.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-basemaps_download_image"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-basemaps_download_image}{}}}
\subsection{Method \code{basemaps_download_image()}}{
Function Downloads a seamline image using the WMS method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$basemaps_download_image(
  bbox,
  srsname = "EPSG:4326",
  height = NULL,
  width = NULL,
  img_format = "jpeg",
  download = TRUE,
  seamlines = FALSE,
  outputpath
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bbox}}{Type:str, Bounding box of the AOI. Comma delimited set of coordinates. (miny,minx,maxy,maxx)}

\item{\code{srsname}}{Type:str, The desired projection. Defaults to EPSG:4326}

\item{\code{height}}{Type:int, The vertical number of pixels to return. Defaults to 512}

\item{\code{width}}{Type:int, The horizontal number of pixels to return. Defaults to 512}

\item{\code{img_format}}{Type: str, The format of the response image either jpeg, png or geotiff}

\item{\code{download}}{Type: bool, User option to download file locally. Default True}

\item{\code{outputpath}}{Type: str Output path must include output format. Downloaded path default is user home path.}

\item{\code{zoom_level}}{Type: int, The zoom level. Used for WMTS}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-basemaps_download_tiles"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-basemaps_download_tiles}{}}}
\subsection{Method \code{basemaps_download_tiles()}}{
Function downloads all tiles within a bbox dependent on zoom level
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$basemaps_download_tiles(
  bbox,
  zoom_level,
  srsname = "EPSG:4326",
  img_format = "jpeg",
  seamlines = FALSE,
  outputpath = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bbox}}{Type:str, Bounding box of the AOI. Comma delimited set of coordinates. (miny,minx,maxy,maxx)}

\item{\code{zoom_level}}{Type: int, The zoom level. Used for WMTS}

\item{\code{srsname}}{Type:str, The desired projection. Defaults to EPSG:4326}

\item{\code{img_format}}{Type: str, The format of the response image either jpeg, png or geotiff}

\item{\code{outputpath}}{Type: str Output path must include output format. Downloaded path default is user home path.}

\item{\code{download}}{Type: bool, User option to download file locally. Default True}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-discovery_stac_search"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-discovery_stac_search}{}}}
\subsection{Method \code{discovery_stac_search()}}{
Returns a list of STAC items
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$discovery_stac_search(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collections}}{(string) = Comma-separated list of collections to search in. Use str format not a Python list}

\item{\code{sub_catalog_id}}{(string) = Name of the subCatalogId to search in}

\item{\code{sub_catalog_collection}}{(string) = Used to denote collections inside of sub catalogs}

\item{\code{bbox}}{(string) = Bounding box in format "minx,miny,maxx,maxy" in WGS84 decimal degrees}

\item{\code{datetime}}{(string) = Date range filter in ISO 8601 format "start-date/end-date" or exact datetime}

\item{\code{stac_id}}{(string) = Comma-separated list of STAC item IDs to return. Use str format not a Python list}

\item{\code{intersects}}{(string) = GeoJSON geometry to search by}

\item{\code{where}}{(string) = SQL-style WHERE clause for filtering STAC items by properties}

\item{\code{orderby}}{(string) = SQL-style ORDER BY clause. Only for id and datetime e.g. 'orderby=id'}

\item{\code{limit}}{(int) = Maximum number of items to return}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-discovery_search_by_audit_fields"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-discovery_search_by_audit_fields}{}}}
\subsection{Method \code{discovery_search_by_audit_fields()}}{
Retrieve items for a given collectionId by audit fields
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$discovery_search_by_audit_fields(collection_id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection_id}}{(string) = Name of the collection to search e.g. wv01 Required}

\item{\code{audit_insert_date}}{(string) = Date range filter in ISO 8601 format "start-date/end-date" or exact datetime}

\item{\code{audit_update_date}}{(string) = Date range filter in ISO 8601 format "start-date/end-date" or exact datetime}

\item{\code{limit}}{(int) = Maximum number of items to return}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-discovery_get_root_catalog"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-discovery_get_root_catalog}{}}}
\subsection{Method \code{discovery_get_root_catalog()}}{
Returns the root STAC Catalog or STAC Collection that is the entry point for users to browse
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$discovery_get_root_catalog(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-discovery_get_collection_definition"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-discovery_get_collection_definition}{}}}
\subsection{Method \code{discovery_get_collection_definition()}}{
Return a collection definition by collection ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$discovery_get_collection_definition(collection_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection_id}}{(string) = Name of the collection to search e.g. wv01 Required}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-discovery_get_all_collections"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-discovery_get_all_collections}{}}}
\subsection{Method \code{discovery_get_all_collections()}}{
Return definitions for all collections
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$discovery_get_all_collections(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{orderby}}{(string) = SQL-style ORDER BY clause. Only for id and datetime e.g. 'orderby=id ASC' default 'datetime DESC, id ASC'}

\item{\code{limit}}{(int) = Maximum number of items to return}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-discovery_get_stac_item"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-discovery_get_stac_item}{}}}
\subsection{Method \code{discovery_get_stac_item()}}{
View details about a specific STAC item
 Dictionary of the desired item's information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$discovery_get_stac_item(collection_id, item_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection_id}}{(string) = Name of the collection to search e.g. wv01}

\item{\code{item_id}}{(string) = Identifier of the desired item}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-discovery_get_top_level_sub_catalog"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-discovery_get_top_level_sub_catalog}{}}}
\subsection{Method \code{discovery_get_top_level_sub_catalog()}}{
View the available Maxar Sub-Catalogs that can be navigated as a self-contained STAC catalog
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$discovery_get_top_level_sub_catalog(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{orderby}}{(string) = SQL-style ORDER BY clause. Only for id and datetime e.g. 'orderby=id ASC' default'datetime DESC, id ASC'}

\item{\code{limit}}{(int) = Maximum number of items to return}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-discovery_get_sub_catalog"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-discovery_get_sub_catalog}{}}}
\subsection{Method \code{discovery_get_sub_catalog()}}{
View the definition of a Maxar Sub-Catalog
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$discovery_get_sub_catalog(sub_catalog_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sub_catalog_id}}{(string) = Identifier of the sub catalog to view}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-discovery_get_sub_catalog_collection_definition"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-discovery_get_sub_catalog_collection_definition}{}}}
\subsection{Method \code{discovery_get_sub_catalog_collection_definition()}}{
View the definition of a collection that belongs to a Sub-Catalog
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$discovery_get_sub_catalog_collection_definition(
  sub_catalog_id,
  sub_catalog_collection_id
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sub_catalog_id}}{(string) = Identifier of the sub catalog to view}

\item{\code{sub_catalog_collection_id}}{(string) = Identifier of the sub catalog collection to view}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Interface-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Interface-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Interface$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
