% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIIVsem-data.R
\docType{data}
\name{bollen1989a}
\alias{bollen1989a}
\title{Industrialization-Democracy Data}
\format{
A data frame with 75 rows and 9 variables
}
\usage{
bollen1989a
}
\description{
A dataset from Bollen (1989) containing measures of political 
democracy and industrialization for 75 developing countries 
in 1960 and 1965. The variables are as follows:
}
\details{
\itemize{
  \item y1. freedom of the press, 1960 
  \item y2. freedom of political opposition, 1960 
  \item y3. fairness of elections, 1960 
  \item y4. effectiveness of elected legislature, 1960
  \item y5. freedom of the press, 1965
  \item y6. freedom of political opposition, 1965
  \item y7. fairness of elections, 1965
  \item y8. effectiveness of elected legislature, 1965
  \item x1. natural log of GNP per capita, 1960
  \item x2. natural log of energy consumption per capita, 1960
  \item x3. arcsin of square root of percentage of labor force in industry, 1960
}
}
\examples{

\dontrun{
  model <- '
    Eta1 =~ y1 + y2  + y3  + y4  
    Eta2 =~ y5 + y6  + y7  + y8    
    Xi1  =~ x1 + x2 + x3 
    Eta1 ~ Xi1  
    Eta2 ~ Xi1 
    Eta2 ~ Eta1 
    y1   ~~ y5
    y2   ~~ y4
    y2   ~~ y6
    y3   ~~ y7
    y4   ~~ y8
    y6   ~~ y8 devtools::build_win()
  '
}

}
\references{
Bollen, K. A. (1989). Structural equation models. 
  New York: Wiley-Interscience.
}
\keyword{datasets}
