% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMLR.R
\name{VarY}
\alias{VarY}
\title{Estimantion of the variance of the response Y}
\usage{
VarY(bb, sigma, i, x, tau, la)
}
\arguments{
\item{bb}{Matrix (k x m), k - number of columns (k - 1 - number of regressors), m - number of states, m = 2,3,.. .}

\item{sigma}{Scalar, the standard deviation of the disturbance term}

\item{i}{number (scalar), initial state}

\item{x}{Row-vector of the matrix of predictors X (1 x k), k - number of columns.}

\item{tau}{number (scalar), observed time}

\item{la}{Matrix with the known transition rates \eqn{\lambda_{i,j}}, (m x m), m – number of states}
}
\value{
Estimantion of the variance of the response Y, scalar
}
\description{
This function is used for calculation of the variance of the respone Y (Var(Y))
}
\details{
Function calculates the following expression:
![](varY.png "Fig.3"),
where vector of average sojourn times in each state $t_{i}$ is calculated using function Aver_soj_time
}
\examples{
Xtest <- cbind(rep_len(1,10),c(2,5,7,3,1,1,2,2,3,6), c(5,4,1,2,3,2,3,5,2,2))
tGiven <- matrix (c(0.9,1.18,1,1.6,1.4,1.7,1.9,1.45,1.5,2.14), nrow = 10, ncol = 1)
initState <- matrix (c(2,1,1,2,2,2,1,1,2,1),nrow = 10, ncol = 1)
lambda <- matrix(c(0, 0.33, 0.45, 0), nrow = 2, ncol = 2, byrow = TRUE)
beta <- matrix(c(1, 2, 3, 4, 6, 8), nrow = 3, ncol = 2, byrow = TRUE)
VarY(beta,1,2,Xtest[3,],10,lambda)
}
