% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.r
\docType{data}
\name{minnow}
\alias{minnow}
\title{minnow contains weekly growth data for use with seasonal growth curves}
\format{
A data.frame of mean length-at-time data
\describe{
  \item{week}{the week of sampling minnows for lengths}
  \item{length}{the estimated mean length in the corresponding week in mm}
}
}
\source{
data measured from Figure 2, page 602 in Pitcher, T.J., and P.D M. MacDonald. (1973) 
Two models of seasonal growth. \emph{Journal of Applied Ecology} 10:599–606.
}
\description{
minnow is a dataset of mean length against time in weeks for
    minnows (\emph{Phoxinus phoxinus}), derived from Pitcher & 
    Macdonald (1973) for use when fitting growth curves, especially 
    seasonal growth curves. The data exhibit increases and decreases 
    in length as each year progresses because these are mean lengths 
    rather than individual measurements (which would, more typically,
    be used these days). The data have been read off a graph within 
    the original paper as it is not reported explicitly, and are 
    therefore only approximate, but will do for our purposes (but 
    expect different parameters to those reported in the original 
    paper). This is length at time not age. Though time is being 
    used as a proxy for age there is no age 0.
}
\section{Subjects}{

 \itemize{
   \item seasonal growth curves
   \item von Bertalanffy
   \item Model residuals
 }
}

\examples{
 data(minnow)
 oldpar <- par(no.readonly=TRUE)
 plot1(minnow$week,minnow$length,type="p",pch=16,cex=1.2,
       xlab="Week",ylab="Length mm")
 par(oldpar)
}
