% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.SensSpec.R
\name{print.SensSpec}
\alias{print.SensSpec}
\title{Print for \code{SensSpec} objects}
\usage{
\method{print}{SensSpec}(x, ...)
}
\arguments{
\item{x}{An object for class \code{SensSpec}.}

\item{...}{Further arguments (currently not used).}
}
\value{
No return value, called for side effects.
}
\description{
Print the results for object of class \code{SensSpec}.
}
\details{
Print the results for object of class \code{SensSpec}.
}
\examples{
## Load example data
data(VanDyke)

## Return the first parts of an object
head(VanDyke)

## Extract unique modalities
unique(VanDyke$treatment)

## Extract Unique readers
unique(VanDyke$reader)

## Create binary test results (Y_ijk)
VanDyke$Y <- as.numeric(VanDyke$rating >= 3)

## Example usage of SensSpec function:
senspe_result1 <- SensSpec(data = VanDyke, Modality = treatment,
                           Reader = reader, Case = case,
                           D = truth, Y = Y, percentage = FALSE, digits = 3)
print(senspe_result1)

# Report results as percentage points
senspe_result2 <- SensSpec(data = VanDyke, Modality = treatment,
                           Reader = reader, Case = case,
                           D = truth, Y = Y, percentage = TRUE, digits = 1)
print(senspe_result2)

}
\seealso{
\code{\link[MRMCbinary]{SensSpec}}, \code{\link[base]{print}}
}
\keyword{print}
