% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbOverview.R
\name{dbOverview}
\alias{dbOverview}
\title{Overview of Tables and Views}
\usage{
dbOverview(channel, schema = "dbo", dim = TRUE, peek = 2, ...)
}
\arguments{
\item{channel}{an RODBC connection.}

\item{schema}{database schema.}

\item{dim}{whether to calculate the number of rows and columns for each
table/view.}

\item{peek}{how many column names to show. The value \code{FALSE} has the
same effect as zero.}

\item{\dots}{passed to \code{sqlTables}.}
}
\value{
Data frame containing six columns:
\item{Name}{name of table/view.}
\item{Schema}{database schema.}
\item{Type}{type of table/view.}
\item{Rows}{number of rows.}
\item{Cols}{number of columns.}
\item{First}{first column names.}
}
\description{
Get dimensions and first few column names of tables and views in a database.
}
\details{
The \code{dim = FALSE} option results in faster computation, but the
\verb{Rows} and \verb{Cols} columns will only contain \code{NA} values.
Similarly, the \code{peek = FALSE} results in faster computation, but the
\verb{First} column will only contain \code{NA} values. These options can be
useful to get a quick overview of a large database.
}
\examples{
\dontrun{
con <- odbcConnect("myDatabase")

dbOverview(con)

dbOverview(con, dim=FALSE, peek=FALSE)
}

}
\seealso{
\code{\link[RODBC]{sqlTables}} is the underlying function used to get the
list of tables/views, \code{\link{tableDim}} is used to count rows and
columns, and \code{\link[RODBC]{sqlColumns}} is used to peek at the first
column names.

\code{\link{dbStorage}} shows the storage size of tables and
\code{\link{dbTime}} shows the time when tables/views were created and last
modified.

\code{\link{MSSQL-package}} gives an overview of the package.
}
