% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbStorage.R
\name{dbStorage}
\alias{dbStorage}
\title{Storage Size}
\usage{
dbStorage(channel, total = TRUE, used = FALSE, unused = FALSE)
}
\arguments{
\item{channel}{an RODBC connection.}

\item{total}{whether to calculate total storage size.}

\item{used}{whether to calculate used storage size.}

\item{unused}{whether to calculate unused storage size.}
}
\value{
Data frame containing the following columns:
\item{Name}{name of table/view.}
\item{Schema}{database schema.}
\item{Type}{type of table/view.}
\item{Rows}{number of rows.}
\item{Cols}{number of columns.}
In addition, any of the following columns, depending on which of
\code{total}, \code{used}, and \code{unused} are \code{TRUE}:
\item{TotalKB}{total storage size.}
\item{UsedKB}{used storage size.}
\item{UnusedKB}{unused storage size.}
}
\description{
Get storage size of tables in a database.
}
\note{
Based on \url{https://stackoverflow.com/questions/7892334}.
}
\examples{
\dontrun{
con <- odbcConnect("myDatabase")

dbOverview(con)

dbOverview(con, dim=FALSE, peek=FALSE)
}

}
\seealso{
\code{\link[RODBC]{sqlQuery}} is the underlying function used to query
\verb{sys.tables}, \verb{sys.indexes}, \verb{sys.partitions},
\verb{sys.allocation_units}, and \verb{sys.schemas}.

\code{\link{dbOverview}} shows the dimensions of tables/views and the first
column names, and \code{\link{dbTime}} shows the time when tables/views were
created and last modified.

\code{\link{object.size}} is the base function to return the storage size of
objects inside the R workspace.

\code{\link{MSSQL-package}} gives an overview of the package.
}
