% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbTime.R
\name{dbTime}
\alias{dbTime}
\title{Time Created and Modified}
\usage{
dbTime(channel)
}
\arguments{
\item{channel}{an RODBC connection.}
}
\value{
Data frame containing five columns:
\item{Name}{name of table/view.}
\item{Schema}{database schema.}
\item{Type}{type of table/view.}
\item{Created}{time created.}
\item{Modified}{time last modified.}
}
\description{
Get time information about tables and views: when they were created and when
they were last modified.
}
\examples{
\dontrun{
con <- odbcConnect("myDatabase")

dbTime(con)
}

}
\seealso{
\code{\link[RODBC]{sqlQuery}} is the underlying function used to query
\verb{sys.tables} and \verb{sys.views}.

\code{\link{dbOverview}} shows the dimensions of tables/views and the first
column names, and \code{\link{dbStorage}} shows the storage size of tables.

\code{\link{Sys.time}} is the base function to show the current time.

\code{\link{MSSQL-package}} gives an overview of the package.
}
