% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableNrow.R
\name{tableNrow}
\alias{tableNrow}
\title{Number of Rows}
\usage{
tableNrow(channel, sqtable)
}
\arguments{
\item{channel}{an RODBC connection.}

\item{sqtable}{a database table or view.}
}
\value{
Number of rows as integer.
}
\description{
Return the number of rows in a database table.
}
\examples{
\dontrun{
con <- odbcConnect("myDatabase")

tableNrow(con, "sysusers")
}

}
\seealso{
\code{\link{tableDim}} and \code{\link{tableNcol}} also return the dimensions
of a database table.

\code{\link[RODBC]{sqlQuery}} is the underlying function used to examine the
table rows.

\code{\link{nrow}} is the base function to return the number of rows for data
frames inside the R workspace.

\code{\link{MSSQL-package}} gives an overview of the package.
}
