% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTAFT_IC.R
\name{MTAFT_IC}
\alias{MTAFT_IC}
\title{MTAFT_IC: Multiple Thresholds Accelerated Failure Time Model with Information Criteria}
\usage{
MTAFT_IC(
  Y,
  X,
  delta,
  Tq,
  c0 = 0.299,
  delta0 = 2.01,
  algorithm = c("WBS", "DP"),
  dist_min = 50,
  ncps_max = 4,
  wbs_nintervals = 200
)
}
\arguments{
\item{Y}{the censored logarithm of the failure time.}

\item{X}{the design matrix without the intercept.}

\item{delta}{the censoring indicator.}

\item{Tq}{the threshold values.}

\item{c0}{the penalty factor c0 in the information criteria (IC), default is 0.299.}

\item{delta0}{the penalty factor delta0 in the information criteria (IC), default is 2.01.}

\item{algorithm}{the threshold detection algorithm, either "WBS" or "DP". Default is "WBS".}

\item{dist_min}{the pre-specified minimal number of observations within each subgroup. Default is 50.}

\item{ncps_max}{the pre-specified maximum number of thresholds. Default is 4.}

\item{wbs_nintervals}{the number of random intervals in the WBS algorithm. Default is 200.}
}
\value{
A list with the following components:
\describe{
  \item{params}{the subgroup-specific slope estimates and variance estimates.}
  \item{thres}{the threshold estimates.}
  \item{IC_val}{the IC values for all candidate number of thresholds.}
}
}
\description{
This function implements a method for multiple thresholds accelerated failure time (AFT) model
with information criteria. It estimates the subgroup-specific slope coefficients and variance
estimates, as well as the threshold estimates using either the "WBS" (Wild Binary Segmentation)
or "DP" (Dynamic Programming) algorithm.
}
\examples{
\donttest{
# Generate simulated data with 500 samples and normal error distribution
dataset <- MTAFT_simdata(n = 500, err = "normal")
Y <- dataset[, 1]
delta <- dataset[, 2]
Tq <- dataset[, 3]
X <- dataset[, -c(1:3)]

# Run MTAFT_IC with WBS algorithm
mtaft_ic_result <- MTAFT_IC(Y, X, delta, Tq, algorithm = 'WBS')
mtaft_ic_result$params
mtaft_ic_result$thres
mtaft_ic_result$IC_val
}
}
\references{
(Add relevant references here)
}
