% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predMV.R
\name{predMV}
\alias{predMV}
\title{Predict outcomes 
Predict MV object using a MUVR class object and a X testing set. At present, this function only supports predictions for PLS regression type problems.}
\usage{
predMV(MUVRclassobject, newdata, model = "min")
}
\arguments{
\item{MUVRclassobject}{An 'MUVR' class object}

\item{newdata}{New data for which to predict outcomes}

\item{model}{What type of model to plot ('min', 'mid' or 'max'). Defaults to 'mid'.}
}
\value{
The predicted result based on the MUVR model and the newdata
}
\description{
Predict outcomes 
Predict MV object using a MUVR class object and a X testing set. At present, this function only supports predictions for PLS regression type problems.
}
\examples{
\donttest{
data("freelive2")
nRep <- 2
nOuter <- 4
varRatio <-0.6
regrModel <- MUVR2(X = XRVIP2,
                   Y = YR2,
                   nRep = nRep,
                   nOuter = nOuter,
                   varRatio = varRatio,
                   method = "PLS",
                   modReturn=TRUE)
predMV(regrModel,XRVIP2)
}
}
