% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdCV.R
\name{rdCV}
\alias{rdCV}
\title{Wrapper for repeated double cross-validation without variable selection}
\usage{
rdCV(
  X,
  Y,
  ID,
  nRep = 5,
  nOuter = 6,
  nInner,
  DA = FALSE,
  fitness = c("AUROC", "MISS", "RMSEP", "BER"),
  method = c("PLS", "RF"),
  methParam,
  ML = FALSE,
  modReturn = FALSE,
  logg = FALSE
)
}
\arguments{
\item{X}{Independent variables. NB: Variables (columns) must have names/unique identifiers. NAs not allowed in data. For ML, X is upper half only (X1-X2)}

\item{Y}{Response vector (Dependent variable). For DA (classification), Y should be factor or character. For ML, Y is omitted. For regression, Y is numeric.}

\item{ID}{Subject identifier (for sampling by subject; Assumption of independence if not specified)}

\item{nRep}{Number of repetitions of double CV.}

\item{nOuter}{Number of outer CV loop segments.}

\item{nInner}{Number of inner CV loop segments.}

\item{DA}{Logical for Classification (discriminant analysis) (Defaults do FALSE, i.e. regression). PLS is limited to two-class problems (see `Y` above).}

\item{fitness}{Fitness function for model tuning (choose either 'AUROC' or 'MISS'or 'BER' for classification; or 'RMSEP' (default) for regression.)}

\item{method}{Multivariate method. Supports 'PLS' and 'RF' (default)}

\item{methParam}{List with parameter settings for specified MV method (defaults to ???)}

\item{ML}{Logical for multilevel analysis (defaults to FALSE)}

\item{modReturn}{Logical for returning outer segment models (defaults to FALSE)}

\item{logg}{Logical for whether to sink model progressions to `log.txt`}
}
\value{
An object containing stuff...
}
\description{
Wrapper for repeated double cross-validation without variable selection
}
\examples{
\donttest{
data("freelive2")
nRep <- 2 # Number of MUVR2 repetitions
nOuter <- 4 # Number of outer cross-validation segments
varRatio <- 0.75 # Proportion of variables kept per iteration
method <- 'RF' # Selected core modeling algorithm
regrModel <- rdCV(X = XRVIP2,
                  Y = YR2,
                  nRep = nRep,
                  nOuter = nOuter,
                  method = method,
                  modReturn=TRUE)
}
}
