% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madantextnetwork.r
\name{fun.all.sums}
\alias{fun.all.sums}
\title{Apply Suffix Modifications to Persian Words}
\usage{
fun.all.sums(v, TYPE = TYPE.org)
}
\arguments{
\item{v}{A character vector of Persian words.}

\item{TYPE}{A vector of suffix types for modification.}
}
\value{
Returns a character vector where each element corresponds to a word
from the input vector `v` with all specified suffix modifications applied.
This results in a transformed vector where each word has been modified
according to the series of suffix types provided in `TYPE`. The length
of the returned vector matches the length of the input vector.
}
\description{
This function iteratively applies a series of suffix modifications to a vector of Persian words.
}
\examples{
\dontrun{
  words <- c("Persian text here")
  modified_words <- fun.all.sums(words, TYPE)
}
}
