% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.R
\name{is.mimids}
\alias{is.mimids}
\title{Checks for the \code{mimids} Class}
\usage{
is.mimids(object)
}
\arguments{
\item{object}{This argument specifies the object that should be checked to see if it is of the \code{mimids} class or not.}
}
\value{
This function returns a logical value indicating whether \code{object} is of the \code{mimids} class.
}
\description{
\code{is.mimids()} function checks whether class of objects is \code{mimids} or not.
}
\details{
The class of objects is checked to be of the \code{mimids}.
}
\examples{
\donttest{#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice::mice(osteoarthritis, m = 5)

#Matching the multiply imputed datasets
matched.datasets <- matchthem(OSP ~ AGE + SEX + BMI + RAC + SMK,
                              imputed.datasets,
                              approach = 'within',
                              method = 'nearest')

#Checking the 'matched.datasets' object
is.mimids(matched.datasets)}
}
\seealso{
\code{\link[=matchthem]{matchthem()}}

\code{\link{mimids}}

\code{\link[=inherits]{inherits()}}
}
\author{
Farhad Pishgar
}
