% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MVEgger-class}
\alias{MVEgger-class}
\title{MVEgger Class}
\description{
An object containing the estimates produced using the multivariable MR-Egger method as well as various statistics.
}
\section{Slots}{

\describe{
\item{\code{Model}}{Model always takes the value \code{random}, as only random-effects analyses are permitted.}

\item{\code{Orientate}}{The number of the risk factor that genetic associations are orientated to. The default value is \code{1}, meaning that genetic associations with the first risk factor are set to be positive.}

\item{\code{Exposure}}{The names of the exposure variables.}

\item{\code{Outcome}}{The name of the outcome variable.}

\item{\code{Correlation}}{The matrix of correlations between genetic variants.}

\item{\code{Estimate}}{The causal estimates from the inverse-variance weighted method.}

\item{\code{StdError.Est}}{The standard errors associated with \code{Estimate}.}

\item{\code{CILower.Est}}{The lower bounds of the confidence interval for \code{Estimate} based on \code{StdError}.}

\item{\code{CIUpper.Est}}{The upper bounds of the confidence interval for \code{Estimate} based on \code{StdError}.}

\item{\code{Pvalue.Est}}{P-value associated with the causal estimate.}

\item{\code{Intercept}}{The intercept estimate from the MR-Egger method. Under the InSIDE assumption, the intercept represents the average pleiotropic effect (average direct effect on the outcome) of a genetic variant. If the intercept differs from zero, this is evidence that the genetic variants are not all valid instruments; specifically, there is directional pleiotropy.}

\item{\code{StdError.Int}}{The standard error associated with \code{Intercept}.}

\item{\code{CILower.Int}}{The lower bound of the confidence interval for \code{Intercept} based on \code{StdError.Int}.}

\item{\code{CIUpper.Int}}{The upper bound of the confidence interval for \code{Estimate} based on \code{StdError.Int}.}

\item{\code{Pvalue.Int}}{P-value associated with the intercept.}

\item{\code{Alpha}}{The significance level used in constructing the confidence interval (default is 0.05).}

\item{\code{SNPs}}{The number of SNPs that were used in the calculation.}

\item{\code{RSE}}{The estimated residual standard error from the regression model.}

\item{\code{Heter.Stat}}{Heterogeneity statistic (Cochran's Q statistic) and associated p-value: the null hypothesis is that all genetic variants estimate the same causal parameter; rejection of the null is an indication that one or more variants may be pleiotropic.}
}}

