% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_edge_assignment.R
\name{load_edge_assignment}
\alias{load_edge_assignment}
\title{Efficiently loads an EDGE-produced taxonomic assignment from a file.
An assumption has been made -- since EDGE tables are generated in an automated fashion,
they should be properly formatted -- thus the code doesn't check for any inconsistencies except
for the very file existence. Note however, the unassigned to taxa entries are removed.
This implementation fully relies on the fread function from data.table package
gaining performance over traditional R techniques.}
\usage{
load_edge_assignment(filepath, type)
}
\arguments{
\item{filepath}{the path to EDGE-generated tab-delimited taxonomy assignment file.}

\item{type}{the assignment type. Following types are recognized: 'bwa', 'diamond',
'gottcha', 'gottcha2', 'kraken', 'metaphlan', and 'pangia'.}
}
\value{
a data frame containing four columns: TAXA, LEVEL, COUNT, and ABUNDANCE, representing
        taxonomically anchored sequences from the sample.
}
\description{
Efficiently loads an EDGE-produced taxonomic assignment from a file.
An assumption has been made -- since EDGE tables are generated in an automated fashion,
they should be properly formatted -- thus the code doesn't check for any inconsistencies except
for the very file existence. Note however, the unassigned to taxa entries are removed.
This implementation fully relies on the fread function from data.table package
gaining performance over traditional R techniques.
}
\examples{
pa_fpath <- system.file("extdata", "HMP_even//allReads-pangia.list.txt", package="MetaComp")
pangia_assignment = load_edge_assignment(pa_fpath, type = "pangia")

table(pangia_assignment$LEVEL)

pangia_assignment[pangia_assignment$LEVEL == "phylum",]

}
