% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8.net_compare.R
\name{c_net_highlight}
\alias{c_net_highlight}
\title{Highlight specific nodes in a network}
\usage{
c_net_highlight(graph, nodes = NULL, edges = NULL, gray_color = "gray80")
}
\arguments{
\item{graph}{An igraph/metatnet object}

\item{nodes}{Vector of node names to highlight}

\item{edges}{a data.frame of edges to highlight, colnames must be "from" and "to"}

\item{gray_color}{Color for non-highlighted nodes (default: "gray80")}
}
\value{
metanet
}
\description{
Adds highlight markers to specified nodes and grays out non-highlighted nodes.
Preserves all existing vertex/edge attributes and class structure.
}
\examples{
par(mfrow = c(1, 3))
nodes <- c("s__Kribbella_catacumbae", "s__Verrucosispora_andamanensis")
nodes <- V(c_net_ego(co_net, nodes))$name
g_hl <- c_net_highlight(co_net, nodes = nodes)
plot(g_hl) # Highlighted nodes keep colors, others turn gray
get_e(co_net) \%>\% head(20) -> hl_edges
g_hl2 <- c_net_highlight(co_net, edges = hl_edges[, 2:3])
c_net_plot(g_hl2)
g_hl3 <- c_net_highlight(co_net, nodes = nodes, edges = hl_edges[, 2:3])
c_net_plot(g_hl3)
}
