% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2-2.manipulate.R
\name{links_stat}
\alias{links_stat}
\title{Link summary of the network}
\usage{
links_stat(
  go,
  group = "v_class",
  e_type = "all",
  topN = 10,
  colors = NULL,
  mode = 1,
  plot_param = list()
)
}
\arguments{
\item{go}{igraph or metanet}

\item{group}{summary which group of vertex attribution in names(vertex_attr(go))}

\item{e_type}{"positive", "negative", "all"}

\item{topN}{topN of group, default: 10}

\item{colors}{colors}

\item{mode}{1~2}

\item{plot_param}{plot parameters}
}
\value{
plot
}
\description{
Link summary of the network
}
\examples{
if (requireNamespace("circlize")) {
  links_stat(co_net, topN = 10)
  module_detect(co_net) -> co_net_modu
  links_stat(co_net_modu, group = "module")
}
if (requireNamespace("corrplot")) {
  links_stat(co_net, topN = 10, mode = 2)
}
}
\seealso{
Other topological: 
\code{\link{extract_sample_net}()},
\code{\link{fit_power}()},
\code{\link{get_group_skeleton}()},
\code{\link{nc}()},
\code{\link{net_par}()},
\code{\link{rand_net}()},
\code{\link{rand_net_par}()},
\code{\link{smallworldness}()}
}
\concept{topological}
