% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-4.other_plot.R
\name{plot.ggig}
\alias{plot.ggig}
\title{Plot a ggig}
\usage{
\method{plot}{ggig}(
  x,
  coors = NULL,
  ...,
  labels_num = NULL,
  vertex_size_range = NULL,
  edge_width_range = NULL,
  plot_module = FALSE,
  mark_module = FALSE,
  mark_color = NULL,
  mark_alpha = 0.3,
  module_label = FALSE,
  module_label_cex = 2,
  module_label_color = "black",
  module_label_just = c(0.5, 0.5),
  legend_number = FALSE,
  legend = TRUE,
  legend_cex = 1,
  legend_position = c(left_leg_x = -2, left_leg_y = 1, right_leg_x = 1.2, right_leg_y =
    1),
  group_legend_title = NULL,
  group_legend_order = NULL,
  color_legend = TRUE,
  color_legend_order = NULL,
  size_legend = FALSE,
  size_legend_title = "Node Size",
  edge_legend = TRUE,
  edge_legend_title = "Edge type",
  edge_legend_order = NULL,
  width_legend = FALSE,
  width_legend_title = "Edge width",
  lty_legend = FALSE,
  lty_legend_title = "Edge class",
  lty_legend_order = NULL,
  params_list = NULL,
  seed = 1234
)
}
\arguments{
\item{x}{ggig object}

\item{coors}{the coordinates you saved}

\item{...}{additional parameters for \code{\link[igraph]{igraph.plotting}}}

\item{labels_num}{show how many labels, >1 indicates number, <1 indicates fraction, "all" indicates all.}

\item{vertex_size_range}{the vertex size range, e.g. c(1,10)}

\item{edge_width_range}{the edge width range, e.g. c(1,10)}

\item{plot_module}{logical, plot module?}

\item{mark_module}{logical, mark the modules?}

\item{mark_color}{mark color}

\item{mark_alpha}{mark fill alpha, default 0.3}

\item{module_label}{show module label?}

\item{module_label_cex}{module label cex}

\item{module_label_color}{module label color}

\item{module_label_just}{module label just, default c(0.5,0.5)}

\item{legend_number}{legend with numbers}

\item{legend}{all legends}

\item{legend_cex}{character expansion factor relative to current par("cex"), default: 1}

\item{legend_position}{legend_position, default: c(left_leg_x=-1.9,left_leg_y=1,right_leg_x=1.2,right_leg_y=1)}

\item{group_legend_title}{group_legend_title, length must same to the numbers of v_group}

\item{group_legend_order}{group_legend_order vector}

\item{color_legend}{logical}

\item{color_legend_order}{color_legend_order vector}

\item{size_legend}{logical}

\item{size_legend_title}{size_legend_title}

\item{edge_legend}{logical}

\item{edge_legend_title}{edge_legend_title}

\item{edge_legend_order}{edge_legend_order vector, e.g. c("positive","negative")}

\item{width_legend}{logical}

\item{width_legend_title}{width_legend_title}

\item{lty_legend}{logical}

\item{lty_legend_title}{lty_legend_title}

\item{lty_legend_order}{lty_legend_order}

\item{params_list}{a list of parameters, e.g. list(edge_legend = TRUE, lty_legend = FALSE), when the parameter is duplicated, the format argument will be used rather than the argument in params_list.}

\item{seed}{random seed, default:1234, make sure each plot is the same.}
}
\value{
ggplot
}
\description{
Plot a ggig
}
\seealso{
Other plot: 
\code{\link{as.ggig}()},
\code{\link{c_net_plot}()},
\code{\link{input_cytoscape}()},
\code{\link{input_gephi}()},
\code{\link{netD3plot}()},
\code{\link{olympic_rings_net}()},
\code{\link{twocol_edgelist}()},
\code{\link{venn_net}()}
}
\concept{plot}
