% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetabolicSurvClass.R
\docType{class}
\name{cvmv-class}
\alias{cvmv-class}
\title{The cvmv Class.}
\description{
The cvmv Class.
}
\section{Slots}{

\describe{
\item{\code{HRTrain}}{A matrix of survival information for the training dataset.
It has three columns representing the estimated HR, the 95\% lower
confidence interval and the 95\% upper confidence interval.}

\item{\code{HRTest}}{A matrix of survival information for the test dataset.
It has three columns representing the estimated HR, the 95\% lower
confidence interval and the 95\% upper confidence interval.}

\item{\code{Ncv}}{The number of cross validation used}

\item{\code{Mdata}}{The Metabolite data matrix that was used for the analysis either
same as Mdata or a reduced version.}

\item{\code{Progfact}}{The names of prognostic factors used}
}}

\examples{
\donttest{
## GENERATE SOME METABOLIC SURVIVAL DATA WITH PROGNOSTIC FACTORS
Data<-MSData(nPatients=100,nMet=150,Prop=0.5)

## USING THE FUNCTION
Result = CVMajorityvotes(Survival=Data$Survival,Censor=Data$Censor,
Prognostic=Data$Prognostic, Mdata=t(Data$Mdata), Reduce=FALSE,
Select=15, Fold=3, Ncv=10)

## GET THE CLASS OF THE OBJECT
class(Result)     # A "cvmv" Class

##  METHOD THAT CAN BE USED FOR THE RESULT
show(Result)
summary(Result)

}
}
\seealso{
\code{\link[MetabolicSurv]{Majorityvotes}}, \code{\link[MetabolicSurv]{CVPcaPls}}, \code{\link[MetabolicSurv]{SurvPcaClass}}, \code{\link[MetabolicSurv]{SurvPlsClass}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
