% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimateHR.R
\name{EstimateHR}
\alias{EstimateHR}
\title{Classification, Survival Estimation and Visualization}
\usage{
EstimateHR(
  Risk.Scores,
  Data.Survival,
  Prognostic = NULL,
  Plots = FALSE,
  Mean = TRUE,
  Quantile = 0.5
)
}
\arguments{
\item{Risk.Scores}{A vector of risk scores with size equals to number of subjects obtained from (\code{\link[MicrobiomeSurv]{Lasoelascox}}).}

\item{Data.Survival}{A dataframe in which the first column is the Survival and the second column is the Censoring indicator for each subject.}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect}

\item{Plots}{A boolean parameter indicating if plots should be shown. Default is FALSE.}

\item{Mean}{The cut off value for the classifier, default is the mean cutoff}

\item{Quantile}{If user want to use quantile as cutoff point. They need to specify Mean = FALSE and a quantile that they want to use. The default is the median cutoff}
}
\value{
An object of is returned, which is a list with the results of the cox regression and some informative plot concerning survival of the risk group.
  \item{SurvResult}{The cox proportional regression result}
  \item{Riskgroup}{The riskgroup based on the riskscore and the cut off value and length is equal to number of subjects}
  \item{KMplot}{The Kaplan-Meier survival plot of the riskgroup}
  \item{SurvBPlot}{The distribution of the survival in the riskgroup}
}
\description{
The function classifies subjects into Low and High risk groups using the risk scores based on the cut-off point which is the mean of the risk score.
Also visualize survival fit along with HR estimates.
}
\details{
The risk scores obtained using the taxa is then used to generate the risk group by dividing subjects into low and high risk groups.
A Cox model is then fitted with the risk group as covariate in the presence or absence of  prognostic factors and or treatment effect.
The extent of survival in the risk groups is known
}
\examples{
# Prepare data
data(Week3_response)
Week3_response = data.frame(Week3_response)
surv_fam_shan_w3 = data.frame(cbind(as.numeric(Week3_response$T1Dweek),
as.numeric(Week3_response$T1D)))
colnames(surv_fam_shan_w3) = c("Survival", "Censor")
prog_fam_shan_w3 = data.frame(factor(Week3_response$Treatment_new))
colnames(prog_fam_shan_w3) = c("Treatment")
data(fam_shan_trim_w3)
names_fam_shan_trim_w3 =
c("Unknown", "Lachnospiraceae", "S24.7", "Lactobacillaceae", "Enterobacteriaceae", "Rikenellaceae")
fam_shan_trim_w3 = data.matrix(fam_shan_trim_w3[ ,2:82])
rownames(fam_shan_trim_w3) = names_fam_shan_trim_w3
# Obtaning the risk score and data survival
lasso_fam_shan_w3 = Lasoelascox(Survival = surv_fam_shan_w3$Survival,
                                Censor = surv_fam_shan_w3$Censor,
                                Micro.mat = fam_shan_trim_w3,
                                Prognostic = prog_fam_shan_w3,
                                Plots = TRUE,
                                Standardize = TRUE,
                                Alpha = 1,
                                Fold = 4,
                                nlambda = 100,
                                Mean = TRUE)

# Using the function
est_HR_fam_shan_w3 = EstimateHR(Risk.Scores = lasso_fam_shan_w3$Risk.Scores,
                                Data.Survival = lasso_fam_shan_w3$Data.Survival,
                                Prognostic = prog_fam_shan_w3, Plots = TRUE,
                                Mean = TRUE)
}
\seealso{
\code{\link[survival]{coxph}}, \code{\link[MicrobiomeSurv]{Lasoelascox}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
