% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FirstFilter.R
\name{FirstFilter}
\alias{FirstFilter}
\title{This function is used for the first step of filtering which removes OTUs having all zeros (inactive OTUs).
The input is an OTU matrix with rows are OTUs and columns are subjects.}
\usage{
FirstFilter(Micro.mat)
}
\arguments{
\item{Micro.mat}{A large or small microbiome matrix.
A matrix with microbiome profiles where the number of rows should be equal to the number of taxa and number of columns should be equal to number of patients.}
}
\value{
A smaller microbiome matrix.
\item{Micro.mat.trim}{The OTU matrix after removing all inactive OTUs}
}
\description{
This function is used for the first step of filtering which removes OTUs having all zeros (inactive OTUs).
The input is an OTU matrix with rows are OTUs and columns are subjects.
}
\examples{
# Preparing data for analysis at OTU level
data(Week3_otu)
Week3_otu = data.frame(Week3_otu)
otu_mat_w3 = t(data.matrix(Week3_otu[ , 1:2720]))
colnames(otu_mat_w3) = Week3_otu$SampleID
# Filtering first step
otu_w3 = FirstFilter(Micro.mat = otu_mat_w3)
}
\seealso{
\code{\link[MicrobiomeSurv]{FirstFilter}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
