% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestUNey.R
\name{TestUNey}
\alias{TestUNey}
\alias{SimNey}
\title{Test of Goodness of Fit (Uniformity)}
\usage{
TestUNey(x, nrep = 10000, sim = NA, n.min = 30)
}
\arguments{
\item{x}{A vector of values, each in the interval [0,1].}

\item{nrep}{The number of replications used to simulate the Neyman distribution.}

\item{sim}{A vector of simulated values from the Neyman distribution. If sim = NA this vector is generated by the function SimNev, otherwise the vector inputted is used.}

\item{n.min}{The minimum sample size that triggers the use of asymptotic Chi distribution in place of the emprical distribution in the Neyman test of uniformity.}
}
\value{
\item{pn }{The p-value for the test.}
\item{n4 }{The value of the test statistics.}
}
\description{
This routine tests whether the values in a vector x is distributed as uniform (0,1).  
The Neyman's smooth test of fit, as described by Ladwina (1994) is used. 
The p-values are obtained based on a resampling method from uniform (0,1).
}
\examples{
# Example 1
x <- runif(100)
TestUNey(x, nrep = 10000, sim = NA)

# Example 2
x <- runif(30,2,5)
x <- (x-min(x))/(max(x)-min(x))
TestUNey(x, nrep = 10000, sim = NA)

# Example 3
x <- c(0.6,0.6,0.5,0.7,0.3,0.4,0.5,0.4,0.2,0.4,0.2,0.5,0.7,0.1,0.7,0.1,0.5,0.5,0.4,0.6,0.3)
TestUNey(x, nrep = 10000, sim = NA)

}
\references{
Ledwina, T. (1994). ``Data-driven version of neyman's smooth test of fit,'' \emph{Journal of the American Statistical Association,} 89, 1000-1005, \doi{10.2307/2290926}.
}
\author{
Mortaza Jamshidian, Siavash Jalal, and Camden Jansen
}
