% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.MuFiMeshGP.R
\name{predict.MuFiMeshGP}
\alias{predict.MuFiMeshGP}
\title{predict.MuFiMeshGP}
\usage{
\method{predict}{MuFiMeshGP}(object, x, t, ...)
}
\arguments{
\item{object}{an object of class \code{MuFiMeshGP}.}

\item{x}{matrix of new input locations to predict.}

\item{t}{vector or new fidelity levels to use for predictions.}

\item{...}{no other argument.}
}
\value{
\itemize{
  \item \code{mean}: vector of predictive posterior mean.
  \item \code{sd}: vector of predictive posterior standard deviation.
}
}
\description{
The function computes the posterior mean and standard deviation of the
\code{MuFiMeshGP} model.
}
\details{
Prediction of the MuFiMeshGP emulator for any fidelity level.

From the object fitted by \code{\link{MuFiMeshGP}} or \code{\link{update.MuFiMeshGP}}
 the posterior mean and standard deviation are calculated for any input
 location and fidelity level.
 For details, see Boutelet and Sung (2025, <arXiv:2503.23158>).
}
\examples{
# Example code
f <- function(x, t){
  x <- c(x)
  return(exp(-1.4*x)*cos(3.5*pi*x)+sin(40*x)/10*t^2)
}

set.seed(1)
X <- matrix(runif(15,0,1), ncol = 1)
tt <- runif(15,0.5,2)

Y <- f(c(X), tt)

fit.mufimeshgp <- MuFiMeshGP(X, tt, Y)

xx <- matrix(seq(0,1,0.01), ncol = 1)
ftrue <- f(xx, 0)

# predict
pred.mufimeshgp <- predict(fit.mufimeshgp, xx, rep(0,101))

mu <- pred.mufimeshgp$mean
s <- pred.mufimeshgp$sd
lower <- mu + qnorm(0.025)*s
upper <- mu + qnorm(0.975)*s

# plot

oldpar <- par(mfrow = c(1,1))
plot(xx, ftrue, "l", ylim = c(-1,1.3), ylab = "y", xlab = "x")
lines(c(xx), mu, col = "blue")
lines(c(xx), lower, col = "blue", lty = 2)
lines(c(xx), upper, col = "blue", lty = 2)
points(c(X), Y, col = "red")
par(oldpar)

### RMSE ###
print(sqrt(mean((ftrue - mu))^2))

}
\seealso{
\code{\link{MuFiMeshGP}} for the model
}
