% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{ggplot_colors}
\alias{ggplot_colors}
\title{Get the default ggplot color palette or a color palette based on the ggplot
palette, but with sub-colors that differ in their luminance}
\usage{
ggplot_colors(n = 6, h = c(0, 360) + 15, l = c(65, 65))
}
\arguments{
\item{n}{The number of colors in the color palette. If `n` is a vector,
get a color palette, that has `length(n)` different base colors.
For each item in n, the actual colors are equally spaced on
in the luminance range `l` between the upper and lower value.}

\item{h}{The hue range.}

\item{l}{A vector of length 2 that describes the luminance range}
}
\value{
A vector of `sum(n)` colors strings
}
\description{
This is an adapted version of https://stackoverflow.com/a/8197703
}
