% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GVAR.R
\name{GVAR}
\alias{GVAR}
\title{Estimates a GVAR(1) and VARX(1,1,1) models}
\usage{
GVAR(GVARinputs, N, CheckInputs = FALSE)
}
\arguments{
\item{GVARinputs}{list. Inputs for GVAR model estimation:
\enumerate{
       \item  \code{Economies}:  character vector. Contains the \code{C} names of the economies included in the system.
       \item  \code{GVARFactors}: list. All variables used in the estimation of the VARX model \cr
               (see e.g. \code{GVARFactors} file for details);
       \item \code{VARXtype}: Permissible:
 \itemize{
       \item \code{'unconstrained'}: model is estimated without constraints (each equation is estimated individually by ordinary least square);
       \item \code{'constrained: Spanned Factors'}: The model is estimated with the restriction that foreign pricing factors do NOT
                               affect (i) domestic economic variables and (ii) domestic pricing factors (estimation via restricted least squares).
       \item \code{'constrained : [factor_name]'}: The model is estimated with the restriction that the specified risk factor
             is influenced only by its own lagged values and the lagged values of its corresponding star variables.
       (estimation via restricted least squares.)
         }
         \item \code{Wgvar}: The GVAR transition matrix (\code{C x C}) used in the model solution. \cr
                               (See the output from the \code{\link{Transition_Matrix}} function.).
}}

\item{N}{positive integer. Number of country-specific spanned factors.}

\item{CheckInputs}{logical. Whether to perform a prior consistency check on the inputs provided in \code{GVARinputs}. Default is FALSE.}
}
\value{
list. Contains:
\enumerate{
  \item parameters of the country-specific VARX(1,1,1):
    \itemize{
      \item intercept (M + N x 1)
      \item phi_1   (M + N x M + N)
      \item phi_1* (M + N x M + N)
      \item phi_g (M + N x M + N)
      \item Sigma (M + N x G)
    }
  \item parameters of the GVAR:
    \itemize{
      \item F0 (K x K)
      \item F1 (K x K)
      \item Sigma_y (K x K)
    }
}
}
\description{
Estimates a GVAR(1) and VARX(1,1,1) models
}
\section{General Notation}{

\itemize{
  \item \code{C}: number of countries in the system
  \item \code{G}: number of global unspanned factors
  \item \code{M}: number of country-specific unspanned factors
  \item \code{N}: number of country-specific spanned factors
  \item \code{K}: total number of risk factors (K = C x (N + M) + G)
}
}

\examples{
data(GVARFactors)

GVARinputs <- list(
  Economies = c("China", "Brazil", "Mexico", "Uruguay"),
  GVARFactors = GVARFactors, VARXtype = "unconstrained"
)

GVARinputs$Wgvar <- matrix(c(
  0, 0.83, 0.86, 0.38,
  0.65, 0, 0.13, 0.55,
  0.32, 0.12, 0, 0.07,
  0.03, 0.05, 0.01, 0
), nrow = 4, ncol = 4)
N <- 3

GVARPara <- GVAR(GVARinputs, N)

}
\references{
Chudik, A. and Pesaran, M. H. (2016). "Theory and Practice of GVAR modelling" (Journal of Economic Surveys)
}
