% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{MultiSummary}
\alias{MultiSummary}
\title{Summary of significant tests}
\usage{
MultiSummary(xy, x = NULL, y = NULL, fit, alpha = 0.05,
  only.rk = NULL, use.pval = NULL, plot.tests = TRUE, pch = NULL,
  rd = 2, plot.margin = FALSE)
}
\arguments{
\item{xy}{A list, whose first element corresponds to the matrix x as below, and
its second element corresponds to the matrix y as below.
if \code{xy} is not specified, \code{x} and \code{y} need to be assigned.}

\item{x}{A matrix, number of columns = dimension of random vector,
number of rows = number of observations.}

\item{y}{A matrix, number of columns = dimension of random vector,
number of rows = number of observations.}

\item{fit}{An object generated by \code{MultiFIT}.}

\item{alpha}{Numeric, only tests with adjusted \code{p}-values less than \code{alpha}
are presented in the output.}

\item{only.rk}{Positive integer vector. Show only tests that are ranked according to
\code{only.rk} and have adjusted \code{p}-value below \code{alpha}. If left as \code{NULL},
all tests with adjusted \code{p}-values less than \code{alpha}
are presented in the output.}

\item{use.pval}{String, choose between \code{"H"} (for Holm), \code{"Hcorrected"}
(for Holm on corrected \code{p}-values) or \code{"MH"} for modified Holm.
If left \code{NULL}, the order of preference is \code{"MH"}, \code{"Hcorrected"} and
then \code{"H"}, according to which is present in the object \code{fit}.}

\item{plot.tests}{Logical, plot the marginal scatter plots that are associated with
the presented significant tests.}

\item{pch}{Point style for plots. If left as \code{NULL}, a default combination of
crosses and bullets is applied.}

\item{rd}{Numeric, number of figures to round to when presenting ranges of variables.}

\item{plot.margin}{Logical, plot the marginal scatter plot of the margins that
are associated with each significant test, without highlighting which points
are conditioned on and are in the discretized 2x2 contingency table.}
}
\value{
List whose elements are \code{significant.tests}, a data frame that summarizes
the main features of the tests and their overall ranking by \code{p}-value and
\code{original.scale.cuboids}, a list whose number of elements is equal to the number of
significant tests (the same number of rows of the data frame \code{significant.tests}). Each
element corresponds to a test and is a list whose elements are the marginal ranges of
the associated cuboid.
}
\description{
Provide a post-hoc summary of significant tests. See vignettes for further examples.
}
\examples{
set.seed(1)
n = 300
Dx = Dy = 2
x = matrix(0, nrow = n, ncol = Dx)
y = matrix(0, nrow = n, ncol = Dy)
x[,1] = rnorm(n)
x[,2] = runif(n)
y[,1] = rnorm(n)
y[,2] = sin(5 * pi * x[ , 2]) + 1 / 5 * rnorm(n)
fit = MultiFIT(x = x, y = y, verbose = TRUE)
w = MultiSummary(x = x, y = y, fit = fit, alpha = 0.0001)
}
