% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiGroupSequential-package.R
\docType{package}
\name{MultiGroupSequential-package}
\alias{MultiGroupSequential}
\alias{MultiGroupSequential-package}
\title{MultiGroupSequential: Group-Sequential Procedures with Multiple Hypotheses}
\description{
It is often challenging to strongly control the family-wise type-1 error rate in the group-sequential trials with multiple endpoints (hypotheses). The inflation of type-1 error rate comes from two sources (S1) repeated testing individual hypothesis and (S2) simultaneous testing multiple hypotheses. The 'MultiGroupSequential' package is intended to help researchers to tackle this challenge. The procedures provided include the sequential procedures described in Luo and Quan (2023) \doi{10.1080/19466315.2023.2191989} and the graphical procedure proposed by Maurer and Bretz (2013) \doi{10.1080/19466315.2013.807748}. Luo and Quan (2013) describes three procedures, and the functions to implement these procedures are (1) seqgspgx() implements a sequential graphical procedure based on the group-sequential p-values; (2) seqgsphh() implements a sequential Hochberg/Hommel procedure based on the group-sequential p-values; and (3) seqqvalhh() implements a sequential Hochberg/Hommel procedure based on the q-values. In addition, seqmbgx() implements the sequential graphical procedure described in Maurer and Bretz (2013).
}
\references{
Xiaodong Luo & Hui Quan (2023) Some Multiplicity Adjustment
Procedures for Clinical Trials with Sequential Design and Multiple Endpoints,
Statistics in Biopharmaceutical Research,
DOI: 10.1080/19466315.2023.2191989.

Willi Maurer & Frank Bretz (2013) Multiple Testing in Group
Sequential Trials Using Graphical Approaches,
Statistics in Biopharmaceutical Research, 5:4, 311-320,
DOI: 10.1080/19466315.2013.807748
}
\author{
\strong{Maintainer}: Xiaodong Luo \email{Xiaodong.Luo@sanofi.com}

Other contributors:
\itemize{
  \item Hui Quan [contributor]
  \item Sanofi [copyright holder]
}

}
\keyword{internal}
