% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqgspgx.r
\name{seqgspgx}
\alias{seqgspgx}
\title{Sequential graphical procedure based on group-sequential p-values}
\usage{
seqgspgx(
  pm = matrix(rep(c(0.03, 0.04, 0.01), times = 2), ncol = 3, nrow = 2),
  alpha = 0.025,
  W = c(0.6, 0.4),
  G = rbind(c(0, 1), c(1, 0))
)
}
\arguments{
\item{pm}{Numeric matrix of group-sequential p-values for different
hypotheses (in row) at different times (in column).}

\item{alpha}{Numeric scalar of the overall family-wise error rate.}

\item{W}{Numeric vector of the weights of the graph.}

\item{G}{Numeric transition matrix of the graph.}
}
\value{
List with elements
\itemize{
\item \code{rejected}: the index set of rejected hypotheses
\item \code{decisionsm}: rejection decision for each endpoint (row) at each timepoint
(column)
\item \code{cumdecisionsm}: cumulative rejection decision for each endpoint (row) at
each timepoint (column)
}
}
\description{
\code{seqgspgx()} implements the sequential graphical procedure for multiple
hypotheses based on group-sequential p-values.
}
\examples{
seqgspgx(
  pm = matrix(rep(c(0.03, 0.04, 0.01), times = 2), ncol = 3, nrow = 2),
  alpha = 0.025,
  W = c(0.6, 0.4),
  G = rbind(c(0, 1), c(1, 0))
)
}
\author{
Xiaodong Luo
}
\concept{group-sequential p-values}
