% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiObjMatch.R
\name{get_pairdist_graph}
\alias{get_pairdist_graph}
\title{Distance vs. exclusion}
\usage{
get_pairdist_graph(matching_result)
}
\arguments{
\item{matching_result}{an object returned by the main matching function
dist_bal_match}
}
\value{
No return value, called for visualization of match result
}
\description{
Plotting function that generate sum of pair-wise distance vs.
number of unmatched treated units
}
\examples{
## Generate matches 
data("lalonde", package="cobalt")
ps_cols <- c("age", "educ", "married", "nodegree", "race")
treat_val <- "treat"
response_val <- "re78"  
pair_dist_val <- c("age", "married", "educ", "nodegree", "race")
my_bal_val <- c("race")
r1s <- c(0.01,1,2,4,4.4,5.2,5.4,5.6,5.8,6)
r2s <- c(0.001)
match_result <- dist_bal_match(data=lalonde, treat_col= treat_val, 
marg_bal_col = my_bal_val, exclusion_penalty=r1s, balance_penalty=r2s, 
dist_col = pair_dist_val, 
propensity_col = ps_cols, max_iter=0)
## Generate visualization of tradeoff between pari-wise distance sum and 
## number of treated units left unmatched
get_pairdist_graph(match_result)
}
\seealso{
Other Graphical helper functions for analysis: 
\code{\link{get_pairdist_balance_graph}()},
\code{\link{get_tv_graph}()}
}
\concept{Graphical helper functions for analysis}
