% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiObjMatch.R
\name{summary.multiObjMatch}
\alias{summary.multiObjMatch}
\title{Generate numerical summary}
\usage{
\method{summary}{multiObjMatch}(
  object,
  type = "penalty",
  cov_list = NULL,
  display_all = TRUE,
  stat = "mean.diff",
  ...
)
}
\arguments{
\item{object}{the matching result returned by either dist_bal_match or
two_dist_match.}

\item{type}{(optional) the type of the summary result in c("penalty",
"exclusion", "balance"). When "penalty" is passed in, the objective
function values and the penalty values are displayed for each match;
when "exclusion" is passed in, the number of units being matched is
displayed for each match; when "balance" is passed in, the covariate
the covariate balance table from bal.tab function in cobalt function
is displayed and user can change \code{covList} to specify the variables to
examine. "penalty" by default.}

\item{cov_list}{(optional) factor of names of covariates that we want to
evaluate covariate balance on if "balance" is passed in for \code{type};
default is NULL. When set to NULL, the
program will compare the covariates that have been used to construct a
propensity model.}

\item{display_all}{(optional) boolean value of whether to display all the
matches if "balance" is passed in for \code{type}; default is TRUE,
where all matches are displayed.}

\item{stat}{(optional) character of the name of the statistic used for
measuring covariate balance  if "balance" is passed in for \code{type};
default is "mean.diff". This argument is the
same as used in "cobalt" package, see: \link[cobalt]{bal.tab}}

\item{\dots}{ignored.}
}
\value{
a summary dataframe of the corresponding type.
}
\description{
Main summary functions for providing tables of numerical
information in matching penalties, objective function values, and balance.
}
