% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{QplicIndx}
\alias{QplicIndx}
\title{Qplication vector}
\usage{
QplicIndx(d, q)
}
\arguments{
\item{d}{dimension of the vectors in the T-product}

\item{q}{power of the Kronecker product}
}
\value{
A vector (T-vector) with all elements previously eliminated by EliminIndx
}
\description{
Restores the duplicated/q-plicated  elements which are eliminated
by  EliminMatr or EliminIndx in a T-product of vectors of dimension d.
It produces the same results as QplicMatr.
}
\examples{
x<-c(1,2,3)
y<-kronecker(kronecker(x,x),x)
## Distinct elements of y
z<-y[EliminIndx(3,3)]
## Restore eliminated elements in z
z[QplicIndx(3,3)]

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021, p.21, (1.31)
}
\seealso{
Other Matrices and commutators: 
\code{\link{EliminIndx}()},
\code{\link{EliminMatr}()},
\code{\link{QplicMatr}()},
\code{\link{SymIndx}()},
\code{\link{SymMatr}()},
\code{\link{UnivMomCum}()}
}
\concept{Matrices and commutators}
