% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateModel.R
\name{CreateModel}
\alias{CreateModel}
\title{Funcao para criar modelos de regressoes multiplas}
\usage{
CreateModel( X, Intercept=TRUE, Simple=FALSE, Quadratic=FALSE,
  InteractionLL=FALSE, InteractionQL=FALSE, InteractionLQ=FALSE,
  InteractionQQ=FALSE)
}
\arguments{
\item{X}{Matriz contendo em cada coluna as variaveis explicativas, ou um
vetor contendo os nomes das variaveis explicativas.}

\item{Intercept}{Indica se deseja-se considerar o intercepto no modelo. Pode ser TRUE (default) ou FALSE.}

\item{Simple}{Indica se deseja-se considerar efeitos simples (lineares) no modelo. Pode ser TRUE (default) ou FALSE.}

\item{Quadratic}{Indica se deseja-se considerar efeitos quadraticos no modelo.  Pode ser TRUE ou FALSE(default).}

\item{InteractionLL}{Indica se deseja-se considerar efeitos de interacao entre efeitos lineares no modelo.  Pode ser TRUE ou FALSE(default).}

\item{InteractionQL}{Indica se deseja-se considerar efeitos de interacao entre efeitos quadraticos com os lineares no modelo.  Pode ser TRUE ou FALSE(default).}

\item{InteractionLQ}{Indica se deseja-se considerar efeitos de interacao entre efeitos lineares com os quadraticos no modelo.  Pode ser TRUE ou FALSE(default).}

\item{InteractionQQ}{Indica se deseja-se considerar efeitos de interacao entre efeitos quadraticos  no modelo.  Pode ser TRUE ou FALSE(default).}
}
\value{
A funcao retorna o modelo de regressao que sera ajustado
}
\description{
Esta funcao cria modelos de regressao multipla indicando se deseja-se considerar
efeitos, lineares, quadraticos e de interacoes.
}
\examples{
data("DadosPalma")
X=DadosPalma[,-7]
model=CreateModel(X,Intercept = TRUE, Simple =TRUE, InteractionLL = TRUE)
model

}
\references{
Tutoriais onlines:
https://www.youtube.com/channel/UCDGyvLCJnv9RtTY1YMBMVNQ
}
\seealso{
\code{\link{lm}}, \code{\link{PredictModel}}, \code{\link{FitModel}}
}
