% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow.R
\name{shadow_replace_binding_missing}
\alias{shadow_replace_binding_missing}
\title{Fix binding resulted missingness in shadow matrices}
\usage{
shadow_replace_binding_missing(
  data,
  shadow,
  id_cols = union(get_id_cols_abcd(), get_id_cols_hbcd()),
  replacement = "Missing due to joining"
)
}
\arguments{
\item{data}{tibble. The data.}

\item{shadow}{tibble. The shadow matrix.}

\item{id_cols}{character (vector). The possible unique identifier columns.
The data does not need to have all of these columns, but if they are
present, they will be used to identify unique rows (Default: identifier
columns used in ABCD and HBCD).
For example, the ABCD data usually has only \code{participant_id} and
\code{session_id}, so if \code{run_id} is provided, it will be ignored.}

\item{replacement}{character. The value to replace the missing values with.}
}
\value{
A tibble of the shadow matrix with missing values replaced.
}
\description{
This function replaces the missing values in the shadow matrices.
This is done by checking if the values in
shadow matrices are both NA. If they are, the value in the shadow
matrix is replaced with \verb{Missing due to joining}.
}
\details{
Data and shadow requirements: The two dataframes must have the same
columns and the same number of rows. They must have the same column names,
but the order of the columns does not matter. It is recommended to
use the same column order and the same row order (by ID columns) in both
dataframes, which saves some processing time.
}
\examples{
\dontshow{if (requireNamespace("NBDCtoolsData", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
shadow <- tibble::tibble(
  participant_id = c("1", "2", "3"),
  session_id = c("1", "2", "3"),
  var1 = c("Unknown", NA, NA),
  var2 = c("Wish not to answer", NA, NA)
)
data <- tibble::tibble(
  participant_id = c("1", "2", "3"),
  session_id = c("1", "2", "3"),
  var1 = c(NA, NA, 1),
  var2 = c(NA, 2, NA)
)
shadow_replace_binding_missing(data, shadow)
\dontshow{\}) # examplesIf}
}
