% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_trend.R
\name{linear_trend}
\alias{linear_trend}
\title{Generation of a linear trend that starts in a given period}
\usage{
linear_trend(j, lambda, sample_size)
}
\arguments{
\item{j}{Time points for which the trend should be generated.}

\item{lambda}{Strength of time trend.}

\item{sample_size}{Vector of dimension 2, indicating sample size in the trial period until the time trend starts and the remaining sample size.}
}
\value{
Time trend for time points j.
}
\description{
This function generates a time trend for given time points in the trial according to a linear function.
}
\details{
The time trend is generated according to the function \eqn{f(j) = \lambda \cdot \frac{j-1}{N-1}}, where \eqn{N} is the total sample size.
}
\author{
Marta Bofill Roig, Pavla Krotka
}
