% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_study.R
\name{sim_study}
\alias{sim_study}
\title{Wrapper function performing simulation studies for a given set of scenarios (not parallelized)}
\usage{
sim_study(
  nsim,
  scenarios,
  arms,
  models = c("fixmodel", "sepmodel", "poolmodel"),
  endpoint,
  verbose = TRUE
)
}
\arguments{
\item{nsim}{Integer. Number of replications. Must be larger than 1.}

\item{scenarios}{Data frame containing all parameters for scenarios that should be simulated.}

\item{arms}{Integer vector with treatment arms to perform inference on. These arms are compared to the control group. Default - all arms except the first one.}

\item{models}{Character vector with models that should be used for the analysis. Default=c("fixmodel", "sepmodel", "poolmodel"). Available models for continuous endpoints are: 'fixmodel', 'fixmodel_cal', 'gam', 'MAPprior', 'mixmodel', 'mixmodel_cal', 'mixmodel_AR1', 'mixmodel_AR1_cal', 'piecewise', 'piecewise_cal', 'poolmodel', 'sepmodel', 'sepmodel_adj', 'splines', 'splines_cal', 'timemachine'. Available models for binary endpoints are: 'fixmodel', 'fixmodel_cal', 'MAPprior', 'poolmodel', 'sepmodel', 'sepmodel_adj', 'timemachine'.}

\item{endpoint}{Endpoint indicator. "cont" for continuous endpoints, "bin" for binary endpoints.}

\item{verbose}{Logical. Indicates whether to print a message (system time and number of finished scenarios) after simulating each scenario in order to track the progress of the simulations. Default=TRUE.}
}
\value{
Data frame with all considered scenarios and corresponding results - the probability to reject \eqn{H_0}.
}
\description{
This function performs a simulation study for a given set of scenarios, analyzing simulated data using different models as indicated by the user. Performs inference for indicated experimental treatment arms. Simulates the probability to reject \eqn{H_0} based on a given number of replications.
}
\examples{

\donttest{
# Create data frame with all parameters:
sim_scenarios <- data.frame(num_arms = 4,
n_arm = 250,
d1 = 250*0,
d2 = 250*1,
d3 = 250*2,
d4 = 250*3,
period_blocks = 2,
mu0 = 0,
sigma = 1,
theta1 = 0,
theta2 = 0,
theta3 = 0,
theta4 = 0,
lambda0 = rep(seq(-0.15, 0.15, length.out = 9), 2),
lambda1 = rep(seq(-0.15, 0.15, length.out = 9), 2),
lambda2 = rep(seq(-0.15, 0.15, length.out = 9), 2),
lambda3 = rep(seq(-0.15, 0.15, length.out = 9), 2),
lambda4 = rep(seq(-0.15, 0.15, length.out = 9), 2),
trend = c(rep("linear", 9), rep("stepwise_2", 9)),
alpha = 0.025,
ncc = TRUE)

# Run simulation study:
sim_results <- sim_study(nsim = 100, scenarios = sim_scenarios, arms = c(3, 4),
models = c("fixmodel", "sepmodel", "poolmodel"), endpoint = "cont")
}


}
\author{
Pavla Krotka
}
