% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NSR_template.R
\name{NSR_template}
\alias{NSR_template}
\title{Make a template for an NSR query}
\usage{
NSR_template(nrow = 1)
}
\arguments{
\item{nrow}{The number of rows to include in the template}
}
\value{
Template data.frame that can be populated and then used in NSR queries.
}
\description{
NSR_template builds a template that can be populated to submit an NSR query.
}
\examples{
\dontrun{

template<-NSR_template(nrow = 2)
template$genus<-"Acer"
template$species<-c("Acer rubrum", "Acer saccharum")
template$country<-"Canada"
template$user_id<-1:2
results <- NSR(occurrence_dataframe = template)

}
}
