% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC_per_reader_nest.R
\name{AUC_per_reader_nest}
\alias{AUC_per_reader_nest}
\title{MRMC analysis in nested data problem}
\usage{
AUC_per_reader_nest(data)
}
\arguments{
\item{data}{The nested data for analysis. This dataset should have specified columns:
"patient","reader1","reader2","reader3","reader4","reader5","truth","mod","region".}
}
\value{
This function returns a \link{list} containing three dataframes.

\if{html}{\out{<div class="sourceCode">}}\preformatted{    Here is a quick summary:

        AUC_per_reader [data.frame] this data frame contains the AUC estimates for each reader under different modalities (Mod1 denotes modality 1 and Mod2 denotes modality 2). 

        AUC_Var_per_reader [data.frame] this data frame contains the AUC variance estimates for each reader under different modalities.
        
        numROI [data.frame] this data frame contains the number of positive and negative ROIs in each case. 
}\if{html}{\out{</div>}}
}
\description{
This function takes nested data as a data frame and runs a multi-reader multi-case analysis for single reader in nested
data problem based on modified U-statistics as described in the following paper:
}
\examples{

 
data = NestMRMC::expected_data

Outputs = AUC_per_reader_nest(data)


}
